/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.client.tools.journal.drawers;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.AgriClientApi;
import com.agricraft.agricraft.api.codecs.AgriSoilCondition;
import com.agricraft.agricraft.api.requirement.AgriSeason;
import com.agricraft.agricraft.api.tools.journal.JournalData;
import com.agricraft.agricraft.api.tools.journal.JournalPageDrawer;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.item.journal.PlantPage;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class PlantPageDrawer
implements JournalPageDrawer<PlantPage> {
    private static final class_2561 GROWTH_STAGES = class_2561.method_43471((String)"agricraft.journal.growth_stages");
    private static final class_2561 GROWTH_REQUIREMENTS = class_2561.method_43471((String)"agricraft.journal.growth_reqs");
    private static final class_2561 PRODUCTS = class_2561.method_43471((String)"agricraft.journal.products");
    private static final class_2561 MUTATIONS = class_2561.method_43471((String)"agricraft.journal.mutations");

    @Override
    public void drawLeftSheet(class_332 guiGraphics, PlantPage page, int pageX, int pageY, JournalData journalData) {
        class_327 font = class_310.method_1551().field_1772;
        guiGraphics.method_25290(GUI_COMPONENTS, pageX + 4, pageY + 9, 0.0f, 56.0f, 128, 20, 128, 128);
        String plantId = AgriApi.getPlantId(page.getPlant()).map(class_2960::toString).orElse("");
        class_2561 plantName = LangUtils.plantName(plantId);
        class_2561 seedName = LangUtils.seedName(plantId);
        int titleWidth = font.method_27525((class_5348)plantName);
        if (titleWidth > 74) {
            float scale = 0.8f;
            while ((float)font.method_27525((class_5348)seedName) * scale > 74.0f) {
                scale -= 0.1f;
            }
            this.drawScaledText(guiGraphics, seedName, pageX + 30, pageY + 15, scale);
        } else {
            guiGraphics.method_51439(font, seedName, pageX + 30, pageY + 15, 0, false);
        }
        guiGraphics.method_51427(AgriSeedItem.toStack(page.getPlant()), pageX + 8, pageY + 11);
        class_2561 plantDescription = LangUtils.plantDescription(plantId);
        float offset = 0.0f;
        if (plantDescription != null) {
            offset = this.drawScaledText(guiGraphics, plantDescription, pageX + 10, pageY + 30, 0.7f);
        }
        pageY = this.drawGrowthRequirements(guiGraphics, page, pageX, pageY, 35.0f + offset);
        this.drawProducts(guiGraphics, page, pageX, pageY);
    }

    @Override
    public void drawRightSheet(class_332 guiGraphics, PlantPage page, int pageX, int pageY, JournalData journalData) {
        this.drawMutations(guiGraphics, page, pageX, pageY);
    }

    protected int drawGrowthRequirements(class_332 guiGraphics, PlantPage page, int pageX, int pageY, float yOffset) {
        int width;
        int dx;
        int i;
        float dy = (float)pageY + Math.max(yOffset, 60.0f);
        dy += (float)(this.drawScaledText(guiGraphics, GROWTH_REQUIREMENTS, pageX + 10, dy, 0.8f) + 1);
        guiGraphics.method_25290(GUI_COMPONENTS, pageX + 10, (int)dy, 0.0f, 36.0f, 66, 8, 128, 128);
        for (i = 0; i < page.brightnessMask().length; ++i) {
            boolean current = page.brightnessMask()[i];
            if (!current) continue;
            boolean prev = i > 0 && page.brightnessMask()[i - 1];
            boolean next = i < page.brightnessMask().length - 1 && page.brightnessMask()[i + 1];
            guiGraphics.method_25293(GUI_COMPONENTS, pageX + 10 + 4 * i + 1, (int)dy, 4, 8, 67.0f, 36.0f, 2, 8, 128, 128);
            if (!prev) {
                guiGraphics.method_25290(GUI_COMPONENTS, pageX + 10 + 4 * i, (int)dy, 66.0f, 36.0f, 1, 8, 128, 128);
            }
            if (next) continue;
            guiGraphics.method_25290(GUI_COMPONENTS, pageX + 10 + 4 * i + 5, (int)dy, 66.0f, 36.0f, 1, 8, 128, 128);
        }
        dy += 9.0f;
        if (AgriApi.getSeasonLogic().isActive()) {
            for (i = 0; i < page.seasonMask().length; ++i) {
                int x = pageX + 75 + i % 2 * 12;
                int y = (int)(dy + 6.0f + (float)(i / 2 * 12));
                if (page.seasonMask()[i]) {
                    guiGraphics.method_25290(GUI_COMPONENTS, x, y, (float)(i * 10), 44.0f, 10, 12, 128, 128);
                    continue;
                }
                guiGraphics.method_25290(GUI_COMPONENTS, x, y, (float)(40 + i * 10), 44.0f, 10, 12, 128, 128);
            }
        }
        for (i = 0; i < page.humidityMask().length; ++i) {
            dx = HUMIDITY_OFFSETS[i];
            width = HUMIDITY_OFFSETS[i + 1] - HUMIDITY_OFFSETS[i];
            if (page.humidityMask()[i]) {
                guiGraphics.method_25290(GUI_COMPONENTS, pageX + dx + 10, (int)dy, (float)dx, 0.0f, width, 12, 128, 128);
                continue;
            }
            guiGraphics.method_25290(GUI_COMPONENTS, pageX + dx + 10, (int)dy, (float)(dx + 53), 0.0f, width, 12, 128, 128);
        }
        dy += 13.0f;
        for (i = 0; i < page.acidityMask().length; ++i) {
            dx = ACIDITY_OFFSETS[i];
            width = ACIDITY_OFFSETS[i + 1] - ACIDITY_OFFSETS[i];
            if (page.acidityMask()[i]) {
                guiGraphics.method_25290(GUI_COMPONENTS, pageX + dx + 10, (int)dy, (float)dx, 12.0f, width, 12, 128, 128);
                continue;
            }
            guiGraphics.method_25290(GUI_COMPONENTS, pageX + dx + 10, (int)dy, (float)(dx + 53), 12.0f, width, 12, 128, 128);
        }
        dy += 13.0f;
        for (i = 0; i < page.nutrientsMask().length; ++i) {
            dx = NUTRIENTS_OFFSETS[i];
            width = NUTRIENTS_OFFSETS[i + 1] - NUTRIENTS_OFFSETS[i];
            if (page.nutrientsMask()[i]) {
                guiGraphics.method_25290(GUI_COMPONENTS, pageX + dx + 10, (int)dy, (float)dx, 24.0f, width, 12, 128, 128);
                continue;
            }
            guiGraphics.method_25290(GUI_COMPONENTS, pageX + dx + 10, (int)dy, (float)(dx + 53), 24.0f, width, 12, 128, 128);
        }
        return (int)(dy + 13.0f);
    }

    protected void drawProducts(class_332 guiGraphics, PlantPage page, int pageX, int pageY) {
        this.drawScaledText(guiGraphics, PRODUCTS, pageX + 10, pageY + 10, 0.8f);
        for (int i = 0; i < page.getProducts().size(); ++i) {
            guiGraphics.method_25290(GUI_COMPONENTS, pageX + 10 + i * 20, pageY + 19, 0.0f, 76.0f, 18, 18, 128, 128);
            guiGraphics.method_51427(page.getProducts().get(i), pageX + 11 + i * 20, pageY + 20);
        }
    }

    protected void drawMutations(class_332 guiGraphics, PlantPage page, int pageX, int pageY) {
        this.drawScaledText(guiGraphics, MUTATIONS, pageX + 10, pageY + 15, 0.8f);
        for (List<class_2960> plants : page.getMutationsOnPage()) {
            guiGraphics.method_25290(GUI_COMPONENTS, pageX + 10, pageY + 24, 0.0f, 76.0f, 86, 18, 128, 128);
            class_1058 parent1 = AgriClientApi.getPlantModel(plants.get(0), (int)AgriApi.getPlant(plants.get(0)).map(plant -> plant.getInitialGrowthStage().total() - 1).orElse(0)).method_4711();
            class_1058 parent2 = AgriClientApi.getPlantModel(plants.get(1), (int)AgriApi.getPlant(plants.get(1)).map(plant -> plant.getInitialGrowthStage().total() - 1).orElse(0)).method_4711();
            class_1058 child = AgriClientApi.getPlantModel(plants.get(2), (int)AgriApi.getPlant(plants.get(2)).map(plant -> plant.getInitialGrowthStage().total() - 1).orElse(0)).method_4711();
            guiGraphics.method_25298(pageX + 11, pageY + 25, 1, 16, 16, parent1);
            guiGraphics.method_25298(pageX + 45, pageY + 25, 1, 16, 16, parent2);
            guiGraphics.method_25298(pageX + 79, pageY + 25, 1, 16, 16, child);
            pageY += 20;
        }
    }

    @Override
    public void drawLeftTooltip(class_332 guiGraphics, PlantPage page, int pageX, int pageY, int mouseX, int mouseY) {
        int w;
        int dx;
        int i;
        class_327 font = class_310.method_1551().field_1772;
        String plantId = AgriApi.getPlantId(page.getPlant()).map(class_2960::toString).orElse("");
        class_2561 plantName = LangUtils.plantName(plantId);
        class_2561 plantDescription = LangUtils.plantDescription(plantId);
        if (8 <= mouseX && mouseX <= 24 && 11 <= mouseY && mouseY <= 27) {
            guiGraphics.method_51438(font, plantName, mouseX + pageX, mouseY + pageY);
            return;
        }
        float offset = 35.0f;
        if (plantDescription != null) {
            offset += (float)this.drawScaledText(guiGraphics, plantDescription, -1000.0f, -1000.0f, 0.7f);
        }
        float dy = Math.max(offset, 60.0f);
        dy += (float)(this.drawScaledText(guiGraphics, GROWTH_REQUIREMENTS, -1000.0f, -1000.0f, 0.8f) + 1);
        for (i = 0; i < page.brightnessMask().length; ++i) {
            if (10 + 4 * i > mouseX || mouseX > 10 + 4 * i + 4 || !(dy + 1.0f <= (float)mouseY) || !((float)mouseY <= dy + 9.0f)) continue;
            guiGraphics.method_51438(font, (class_2561)class_2561.method_43471((String)"agricraft.tooltip.light").method_27693(" " + i), mouseX + pageX, mouseY + pageY);
            return;
        }
        dy += 9.0f;
        if (AgriApi.getSeasonLogic().isActive()) {
            for (i = 0; i < page.seasonMask().length; ++i) {
                int x = 75 + i % 2 * 12;
                int y = (int)(dy + 6.0f + (float)(i / 2 * 12));
                if (x > mouseX || mouseX > x + 10 || y > mouseY || mouseY > y + 12) continue;
                guiGraphics.method_51438(font, LangUtils.seasonName(AgriSeason.values()[i]), mouseX + pageX, mouseY + pageY);
                return;
            }
        }
        for (i = 0; i < page.humidityMask().length; ++i) {
            dx = HUMIDITY_OFFSETS[i] + 10;
            w = HUMIDITY_OFFSETS[i + 1] - HUMIDITY_OFFSETS[i];
            if (dx > mouseX || mouseX > dx + w || !(dy <= (float)mouseY) || !((float)mouseY <= dy + 12.0f)) continue;
            guiGraphics.method_51438(font, LangUtils.soilPropertyName("humidity", AgriSoilCondition.Humidity.values()[i]), mouseX + pageX, mouseY + pageY);
            return;
        }
        dy += 13.0f;
        for (i = 0; i < page.acidityMask().length; ++i) {
            dx = ACIDITY_OFFSETS[i] + 10;
            w = ACIDITY_OFFSETS[i + 1] - ACIDITY_OFFSETS[i];
            if (dx > mouseX || mouseX > dx + w || !(dy <= (float)mouseY) || !((float)mouseY <= dy + 12.0f)) continue;
            guiGraphics.method_51438(font, LangUtils.soilPropertyName("acidity", AgriSoilCondition.Acidity.values()[i]), mouseX + pageX, mouseY + pageY);
            return;
        }
        dy += 13.0f;
        for (i = 0; i < page.nutrientsMask().length; ++i) {
            dx = NUTRIENTS_OFFSETS[i] + 10;
            w = NUTRIENTS_OFFSETS[i + 1] - NUTRIENTS_OFFSETS[i];
            if (dx > mouseX || mouseX > dx + w || !(dy <= (float)mouseY) || !((float)mouseY <= dy + 12.0f)) continue;
            guiGraphics.method_51438(font, LangUtils.soilPropertyName("nutrients", AgriSoilCondition.Nutrients.values()[i]), mouseX + pageX, mouseY + pageY);
            return;
        }
        dy += 33.0f;
        for (i = 0; i < page.getProducts().size(); ++i) {
            if (11 + i * 20 > mouseX || mouseX > 11 + i * 20 + 16 || !(dy <= (float)mouseY) || !((float)mouseY <= dy + 16.0f)) continue;
            guiGraphics.method_51446(font, page.getProducts().get(i), mouseX + pageX, mouseY + pageY);
        }
    }

    @Override
    public void drawRightTooltip(class_332 guiGraphics, PlantPage page, int pageX, int pageY, int mouseX, int mouseY) {
        class_327 font = class_310.method_1551().field_1772;
        int y = 0;
        for (List<class_2960> plants : page.getMutationsOnPage()) {
            if (11 <= mouseX && mouseX <= 27 && y + 25 <= mouseY && mouseY <= y + 41) {
                guiGraphics.method_51438(font, LangUtils.plantName(plants.get(0).toString()), mouseX + pageX, mouseY + pageY);
            } else if (45 <= mouseX && mouseX <= 61 && y + 25 <= mouseY && mouseY <= y + 41) {
                guiGraphics.method_51438(font, LangUtils.plantName(plants.get(1).toString()), mouseX + pageX, mouseY + pageY);
            } else if (79 <= mouseX && mouseX <= 95 && y + 25 <= mouseY && mouseY <= y + 41) {
                guiGraphics.method_51438(font, LangUtils.plantName(plants.get(2).toString()), mouseX + pageX, mouseY + pageY);
            }
            y += 20;
        }
    }
}

